/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.AbstractButtonWidget;
import com.supermartijn642.core.gui.widget.IHoverTextWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LockButton
extends AbstractButtonWidget
implements IHoverTextWidget {
    private boolean locked;

    public LockButton(int x, int y) {
        super(x, y, 20, 20, null);
    }

    public void onPress() {
        super.onPress();
        this.locked = !this.locked;
    }

    protected Component getNarrationMessage() {
        return new TranslatableComponent("gui.narrate.button", new Object[]{new TranslatableComponent("narrator.button.difficulty_lock")}).m_130946_(". ").m_7220_((Component)(this.isLocked() ? new TranslatableComponent("narrator.button.difficulty_lock.locked") : new TranslatableComponent("narrator.button.difficulty_lock.unlocked")));
    }

    public void render(PoseStack matrixStack, int x, int y, float partialTicks) {
        ScreenUtils.bindTexture((ResourceLocation)Button.f_93617_);
        Icon icon = !this.active ? (this.locked ? Icon.LOCKED_DISABLED : Icon.UNLOCKED_DISABLED) : (this.hovered ? (this.locked ? Icon.LOCKED_HOVER : Icon.UNLOCKED_HOVER) : (this.locked ? Icon.LOCKED : Icon.UNLOCKED));
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)this.x, (float)this.y, (float)this.width, (float)this.height, (float)((float)icon.getX() / 256.0f), (float)((float)icon.getY() / 256.0f), (float)0.078125f, (float)0.078125f);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean lockedIn) {
        this.locked = lockedIn;
    }

    public Component getHoverText() {
        return new TranslatableComponent("gui.tesseract.channel." + (this.locked ? "private" : "public"));
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum Icon {
        LOCKED(0, 146),
        LOCKED_HOVER(0, 166),
        LOCKED_DISABLED(0, 186),
        UNLOCKED(20, 146),
        UNLOCKED_HOVER(20, 166),
        UNLOCKED_DISABLED(20, 186);

        private final int x;
        private final int y;

        private Icon(int xIn, int yIn) {
            this.x = xIn;
            this.y = yIn;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }
}

